/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import com.filenet.api.collection.PropertyDescriptionList;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.util.UserContext;
import filenet.pa.sql.ExposedField;
import filenet.pa.util.PAException;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.PADataFieldsNode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.VWTaskJComboBox;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PACESelectEventLogFieldPanel
extends JPanel
implements IVWTaskWizardPanel,
IVWTaskWizardControl,
KeyListener {
    PADataFieldWizard m_wizard = null;
    PADataFieldsNode m_node = null;
    JComboBox m_fieldCombo = null;
    JTextField m_uniqueName = null;
    JTextField m_fieldType = null;
    JTextField m_region = null;
    JCheckBox m_showSystemFields = null;
    String m_fieldName = null;
    int m_nFieldType = -1;
    HashMap<String, CEExposedLogField> m_fields = null;
    HashMap<String, Boolean> m_installedByAddon = null;
    Boolean m_bfirstTimeSetUinqueName = true;
    private static final int MAX_FIELD_NAME_LENGTH = 128;

    public PACESelectEventLogFieldPanel(PADataFieldWizard wizard) throws Exception {
        this.m_wizard = wizard;
        this.m_installedByAddon = new HashMap();
        this.m_installedByAddon.put("CmAcmCommentText", true);
        this.m_installedByAddon.put("CmAcmObjectName", true);
        this.m_installedByAddon.put("CmAcmObjectState", true);
        this.m_installedByAddon.put("CmAcmStepName", true);
        this.m_installedByAddon.put("CmAcmCaseFolder", true);
        this.m_installedByAddon.put("CmAcmDisabledState", true);
        this.m_node = wizard.getDataFieldsNode();
        this.initLayout();
        this.updateControlsWithSelectedField();
    }

    public void initializeFields() throws Exception {
        if (this.m_wizard.getDataFieldNode() != null && "CmAcmCaseIdentifier".compareToIgnoreCase(this.m_wizard.getDataFieldNode().getFieldName()) == 0 || !this.updateFieldCombo(false)) {
            this.m_showSystemFields.setSelected(true);
        }
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add(this.getPEFieldPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(20, 0, 0, 0);
        this.add(this.getUniqueNamePanel(), c);
    }

    private Component getPEFieldPanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ContentEngineEventLogField, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.Field)), c);
        this.m_fieldCombo = new VWTaskJComboBox(new Vector());
        VWTaskUtil.updateComponentOrientation(this.m_fieldCombo);
        this.m_fieldCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    // empty if block
                }
                PACESelectEventLogFieldPanel.this.updateControlsWithSelectedField();
            }
        });
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_fieldCombo, c);
        this.m_showSystemFields = new JCheckBox(VWResource.ShowSystemFields, true);
        this.m_showSystemFields.setSelected(false);
        this.m_showSystemFields.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    PACESelectEventLogFieldPanel.this.updateFieldCombo(PACESelectEventLogFieldPanel.this.m_showSystemFields.isSelected());
                    PACESelectEventLogFieldPanel.this.updateControlsWithSelectedField();
                    PACESelectEventLogFieldPanel.this.m_wizard.getDataFieldsNode().setShowSystemFields(PACESelectEventLogFieldPanel.this.m_showSystemFields.isSelected());
                }
                catch (Exception ex) {
                    VWTaskCore.getInstance().displayError((Throwable)ex, false);
                }
            }
        });
        c.gridx = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_showSystemFields, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.FieldType)), c);
        this.m_fieldType = new JTextField();
        this.m_fieldType.setEditable(false);
        this.m_fieldType.setBorder(null);
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 5);
        panel.add((Component)this.m_fieldType, c);
        return borderPanel;
    }

    private Component getUniqueNamePanel() {
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ProcessAnalyzerUniqueName, 0);
        JPanel panel = borderPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.UniqueName)), c);
        this.m_uniqueName = new JTextField();
        this.m_uniqueName.addKeyListener(this);
        if (!this.m_wizard.isNewDataField()) {
            this.m_uniqueName.setText(this.m_wizard.getDataFieldNode().getName());
        }
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add((Component)this.m_uniqueName, c);
        c.gridx = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 0, 0, 20);
        panel.add(Box.createHorizontalStrut((int)this.m_showSystemFields.getPreferredSize().getWidth()), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add(Box.createHorizontalStrut(0), c);
        return borderPanel;
    }

    @Override
    public void performValidation() throws Exception {
        String uniqueName = this.m_uniqueName.getText();
        int unlen = uniqueName.length();
        int fnlen = this.m_fieldName.length();
        if (unlen == 0 || unlen > 128 || fnlen == 0 || fnlen > 128) {
            throw new PAException("pa.publisher.udf.UDFAdmin.ValidateUDFException", "The length of Unique Name and Field Name should not exceed 128 characters.");
        }
        if (!(!this.m_wizard.isNewDataField() && uniqueName.equals(this.m_wizard.getDataFieldNode().getName()) || this.m_node.isNameUnique(uniqueName))) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.NameIsNotUnique", "The name \"{0}\" has already been used.  Enter a unique name.", uniqueName);
        }
        boolean bValidName = true;
        if (!Character.isLetter(uniqueName.charAt(0))) {
            bValidName = false;
        } else {
            for (int i = 0; i < uniqueName.length(); ++i) {
                if (Character.isLetterOrDigit(uniqueName.charAt(i)) || uniqueName.charAt(i) == '_') continue;
                bValidName = false;
            }
        }
        if (!bValidName) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.InvalidUniqueNameSyntax", "The unique name must begin with a letter and contain only letters, numbers, or underscores.");
        }
        if (this.isReservedWord(uniqueName)) {
            throw new VWException("vw.apps.taskman.pa.PASelectEventLogFieldPanel.CannotUseReservedWord", "The term ''{0}'' is reserved for Case Analyzer internal use and cannot be used as the unique name of a data field.", uniqueName);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getHelpPath() {
        return VWHelp.Help_Process_TaskManager + "pa_data_fields.htm";
    }

    @Override
    public String getInstructions() {
        return VWResource.SelectManualField;
    }

    @Override
    public boolean skipThisPanel() {
        return !this.m_wizard.IsSourceCESelected();
    }

    @Override
    public boolean allowButtonToBeEnabled(int button) {
        if (button == 1) {
            return this.getUniqueName().length() > 0;
        }
        return true;
    }

    public String getFieldName() {
        if (this.m_fieldName == VWResource.CaseIdentifier) {
            return "CmAcmCaseIdentifier";
        }
        return this.m_fieldName;
    }

    public int getFieldType() {
        return this.m_nFieldType;
    }

    public String getUniqueName() {
        return this.m_uniqueName.getText().trim();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.m_wizard != null) {
            this.m_wizard.updateButtonState();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected boolean updateFieldCombo(boolean showSystemFields) throws Exception {
        boolean fieldsPresent = false;
        this.m_fieldCombo.removeAllItems();
        String origFieldType = null;
        if (!this.m_wizard.isNewDataField()) {
            origFieldType = ExposedField.Type.valueOf((int)this.m_wizard.getDataFieldNode().getFieldType()).getName();
        }
        String ceURL = this.m_node.getPANode().getContentEngineURL();
        String user = this.m_node.getPANode().getServiceUsername();
        String password = this.m_node.getPANode().getServicePassword();
        String OsName = this.m_node.getPANode().getObjectStore();
        Connection con = Factory.Connection.getConnection((String)ceURL);
        Subject subject = UserContext.createSubject((Connection)con, (String)user, (String)password, (String)"FileNetP8WSI");
        UserContext uc = UserContext.get();
        uc.pushSubject(subject);
        Domain dom = Factory.Domain.fetchInstance((Connection)con, null, null);
        ObjectStore os = Factory.ObjectStore.fetchInstance((Domain)dom, (String)OsName, null);
        this.m_fields = new HashMap();
        ClassDescription cd = Factory.ClassDescription.fetchInstance((Scope)os, (String)"UpdateEvent", null);
        this.getCustomFields(cd, this.m_fields, showSystemFields, origFieldType);
        cd = Factory.ClassDescription.fetchInstance((Scope)os, (String)"DeletionEvent", null);
        this.getCustomFields(cd, this.m_fields, showSystemFields, origFieldType);
        cd = Factory.ClassDescription.fetchInstance((Scope)os, (String)"CreationEvent", null);
        this.getCustomFields(cd, this.m_fields, showSystemFields, origFieldType);
        cd = Factory.ClassDescription.fetchInstance((Scope)os, (String)"ObjectChangeEvent", null);
        this.getCustomFields(cd, this.m_fields, showSystemFields, origFieldType);
        if (!this.m_fields.isEmpty()) {
            Set<String> keySet = this.m_fields.keySet();
            for (String name : keySet) {
                this.m_fieldCombo.addItem(name);
                fieldsPresent = true;
            }
        }
        if (!this.m_wizard.isNewDataField()) {
            if (this.m_fields.containsKey(this.m_wizard.getDataFieldNode().getFieldName())) {
                this.m_fieldCombo.setSelectedItem(this.m_wizard.getDataFieldNode().getFieldName());
            } else if ("CmAcmCaseIdentifier".compareToIgnoreCase(this.m_wizard.getDataFieldNode().getFieldName()) == 0) {
                this.m_fieldCombo.setSelectedItem(VWResource.CaseIdentifier);
            }
            if (this.m_bfirstTimeSetUinqueName.booleanValue()) {
                this.m_uniqueName.setText(this.m_wizard.getDataFieldNode().getName());
                this.m_bfirstTimeSetUinqueName = false;
            }
        }
        return fieldsPresent;
    }

    private void getCustomFields(ClassDescription cd, HashMap<String, CEExposedLogField> props, boolean showSystemFields, String origFieldType) {
        PropertyDescriptionList pdlist = cd.get_PropertyDescriptions();
        block8: for (PropertyDescription pd : pdlist) {
            if (!pd.get_IsSelectable().booleanValue() || pd.get_Cardinality() != Cardinality.SINGLE || pd.get_DataType() == TypeID.OBJECT || pd.get_IsSystemGenerated().booleanValue() || pd.get_IsSystemOwned().booleanValue() || this.m_installedByAddon.containsKey(pd.get_SymbolicName())) continue;
            CEExposedLogField el = new CEExposedLogField();
            el.SymbolicName = pd.get_SymbolicName();
            el.DisplayName = pd.get_DisplayName();
            switch (pd.get_DataType().getValue()) {
                case 2: {
                    el.Type = "Boolean";
                    break;
                }
                case 8: {
                    el.Type = "String";
                    break;
                }
                case 6: {
                    el.Type = "Int";
                    break;
                }
                case 3: {
                    el.Type = "Time";
                    break;
                }
                case 4: {
                    el.Type = "Float";
                    break;
                }
                case 5: {
                    el.Type = "Guid";
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (el.SymbolicName.compareToIgnoreCase("CmAcmCaseIdentifier") == 0) {
                if (!showSystemFields) continue;
                el.SymbolicName = VWResource.CaseIdentifier;
            }
            if (origFieldType != null && el.Type.compareToIgnoreCase(origFieldType) != 0) continue;
            props.put(el.SymbolicName, el);
        }
        pdlist = cd.get_SuperclassDescription().get_PropertyDescriptions();
        for (PropertyDescription pd : pdlist) {
            if (!props.containsKey(pd.get_SymbolicName())) continue;
            props.remove(pd.get_SymbolicName());
        }
    }

    private void updateControlsWithSelectedField() {
        Object item = this.m_fieldCombo.getSelectedItem();
        if (item != null) {
            String name = (String)item;
            CEExposedLogField field = this.m_fields.get(name);
            try {
                this.m_fieldName = field.getName();
                this.m_nFieldType = field.getFieldType();
                this.m_fieldType.setText(VWFieldType.getLocalizedString(this.m_nFieldType));
                if (this.m_wizard.isNewDataField()) {
                    StringBuffer nameBuffer = field.getName().compareToIgnoreCase(VWResource.CaseIdentifier) == 0 ? new StringBuffer("CmAcmCaseIdentifier") : new StringBuffer(field.getName());
                    if (nameBuffer.length() > 128) {
                        nameBuffer.setLength(128);
                    }
                    this.m_uniqueName.setText(nameBuffer.toString());
                }
            }
            catch (VWException e) {}
        } else {
            this.m_fieldType.setText("");
            if (this.m_wizard.isNewDataField()) {
                this.m_uniqueName.setText("");
            }
            this.m_fieldName = null;
            this.m_nFieldType = -1;
        }
    }

    private boolean isReservedWord(String word) {
        if (word.equalsIgnoreCase("Queue")) {
            return true;
        }
        if (word.equalsIgnoreCase("Status")) {
            return true;
        }
        if (word.equalsIgnoreCase("User")) {
            return true;
        }
        if (word.equalsIgnoreCase("Workflow")) {
            return true;
        }
        if (word.equalsIgnoreCase("Time")) {
            return true;
        }
        if (word.equalsIgnoreCase("Incoming")) {
            return true;
        }
        if (word.equalsIgnoreCase("Outgoing")) {
            return true;
        }
        return word.equalsIgnoreCase("Workload");
    }

    private class CEExposedLogField {
        String SymbolicName;
        String DisplayName;
        String Type;

        private CEExposedLogField() {
        }

        public String getName() {
            return this.SymbolicName;
        }

        public int getFieldType() {
            if (this.Type == null) {
                return -1;
            }
            if (this.Type.equals("Int")) {
                return 1;
            }
            if (this.Type.equals("String") || this.Type.equals("")) {
                return 2;
            }
            if (this.Type.equals("Boolean")) {
                return 4;
            }
            if (this.Type.equals("Float")) {
                return 8;
            }
            if (this.Type.equals("Time")) {
                return 16;
            }
            if (this.Type.equals("Guid")) {
                return 512;
            }
            return -1;
        }
    }
}

